import { Request, Response, NextFunction } from 'express';
import { templatesService } from '../services';
import { templatesQuerySchema } from '../validation/schemas';

export class TemplatesController {
  async getTemplates(req: Request, res: Response, next: NextFunction): Promise<void> {
    try {
      const query = templatesQuerySchema.parse(req.query);

      const templates = await templatesService.getTemplates({
        sportId: query.sportId,
        leagueId: query.leagueId,
        widgetTypeId: query.widgetTypeId,
        participantId: query.participantId,
        featured: query.featured,
        isActive: query.isActive,
      });
      res.json({ templates });
    } catch (error) {
      next(error);
    }
  }
}

export const templatesController = new TemplatesController();
