import mongoose, { Schema, Document } from 'mongoose';
import { Sport } from '../types';

export interface SportDocument extends Omit<Sport, 'id'>, Document {
  id: number;
}

const sportSchema = new Schema<SportDocument>(
  {
    id: { type: Number, required: true, unique: true },
    sportName: { type: String, required: true, unique: true },
    icon: { type: String, default: null },
    isActive: { type: Boolean, default: true },
  },
  {
    timestamps: true,
    toJSON: {
      transform: (_doc, ret: Record<string, unknown>) => {
        delete ret._id;
        delete ret.__v;
        return ret;
      },
    },
  }
);

// Indexes
sportSchema.index({ sportName: 1 });
sportSchema.index({ isActive: 1 });

export const SportModel = mongoose.model<SportDocument>('Sport', sportSchema);
